C MAIN PROGRAM FOR NONLINEAR LEAST-SQUARES DATA FITTING
C
      PARAMETER       (N = 2, LWORK = N*(N+10), MD = 4)
      DOUBLE PRECISION  X0(N), X(N), F, WORK(LWORK), T(MD), B(MD)
      COMMON /EXPDAT/ T, B, M
      EXTERNAL        DCALCF
C
C DATA FOR DATA FITTING
C
      T(1) =  0.0D0
      T(2) =  1.0D0
      T(3) =  2.0D0
      T(4) =  3.0D0
      B(1) = 20.0D0
      B(2) =  9.0D0
      B(3) =  3.0D0
      B(4) =  1.0D0
C
C SPECIFY INITIAL ESTIMATE OF THE SOLUTION
C
      M     = 4
      X0(1) = 1.0D0
      X0(2) = 1.0D0
C
C MINIMIZE FUNCTION
C
      CALL UNCMND (N, X0, DCALCF, X, F, IERROR, WORK, LWORK)
C
C PRINT RESULTS
C
      WRITE (*,*) 'UNCMND FOR NONLINEAR LEAST SQUARES RESULTS'
      IF (IERROR .NE. 0) WRITE (*,*) ' ERROR CODE =', IERROR
      WRITE (*,'(A,1X,D15.8)') ' F(X*) =', F
      WRITE (*,'(1X,A)') ' X* =' 
      WRITE (*,'(5X,D20.12)') (X(I), I = 1,N)
C
      WRITE (*,*) 
      WRITE (*,*) 
     * 'REFERENCE RESULTS (PARTIAL-LAST 8 LINES) FROM IBM PC/AT'
      WRITE (*,*) '-0.52716742E+01  -0.20203044E+02  -0.57189483E+01'
      WRITE (*,*) ' 0.20000000E+02  -0.20605341E+02  -0.52716742E+01'
      WRITE (*,*) ' 0.20000001E+02  -0.20605341E+02  -0.52716742E+01'    
      WRITE (*,*) ' 0.20000000E+02  -0.20605340E+02  -0.52716742E+01'
      WRITE (*,*) 'UNCMND WARNING -- INFO = 1: PROBABLY CONVERGED, GRADI
     *ENT SMALL'
      WRITE (*,*) 'UNCMND FOR NONLINEAR LEAST SQUARES RESULTS'
      WRITE (*,*) ' ERROR CODE =           1'
      WRITE (*,*) ' F(X*) =  0.91000000E+02'
      WRITE (*,*) ' X* = '
      WRITE (*,*) '     0.200000001134E+02'
      WRITE (*,*) '    -0.206053408470E+02'    
C
      STOP
      END
C
C OBJECTIVE FUNCTION
C
      SUBROUTINE DCALCF (N, X, F)
      DOUBLE PRECISION  X(N), F, T(4), B(4)
      COMMON /EXPDAT/ T, B, M
C
      F = 0.0D0
      WRITE (*,'(1X,D15.8,2X,D15.8,2X,D15.8)') X(1),X(2),X(3)
      DO 10 J = 1,M
         F = F + (B(J) - X(1)*EXP(X(2)*T(J)))**2.0D0
10    CONTINUE
C
      RETURN
      END
